/*------------------------------------------------------------------------------*
 * File Name: GetNPrevwDlg2.h 													*
 * Creation: ML 2/13/2006														*
 * Purpose: A General GetN dialog with a Graph Preview tab						*
 * Copyright (c) OriginLab Corp.	2006, 2007, 2008, 2009, 2010, 2011			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#ifndef	__GETNPREWDLG2_H_
#define	__GETNPREWDLG2_H_
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#define		TREE_CTRL_VAR		m_treeDynaControl

//////////////////////////////////////////////////////////////////////////////
// class TreeEditDlg2
//////////////////////////////////////////////////////////////////////////////
class TreeEditDlg2 : public BASE_WINDOW
{
public:
	TreeEditDlg2(UINT nDlgID, LPCSTR lpcszDLL) :  BASE_WINDOW(nDlgID, lpcszDLL)
	{
	}
	
public:
	BOOL OnReconstructGrid(uint wParam, uint lParam)
	{
		//if(m_treeEditCntrl.OnReconstructGrid(wParam, lParam))
		//	ResizeDlgToFit();
		
		// For now just set again the entire tree:
		TreeNode		tree = TREE_CTRL_VAR.GetTreeNode(-1);
		if (!tree.IsValid())
		{
			ASSERT(FALSE);
			return FALSE;
		}
		
		update(tree, true, false, false);

		return TRUE;
	}
	
	virtual BOOL OnDestroy(void)
	{
		//m_treeEditCntrl.OnDestroy();
		BASE_WINDOW::OnDestroy();
		return true;
	}
	
	virtual void ConstructWithoutTree()
	{
		GETN_TREE(trTemp)
		//GETN_STR(empty, "", "") GETN_READ_ONLY
		GETN_STR(empty, "Empty", "String")
		m_paramTree=trTemp;
		//m_treeEditCntrl.Init(GetTreeEditPaneID(), false, true, NULL, *this);	///DG INIT_ONE_TIME
		//m_treeEditCntrl.Update(m_paramTree, true, true);
		update(m_paramTree, true, true);
	}

protected:
	BOOL				update(TreeNode &tr, bool bResize = true, bool bInit = false, bool bCallNodesHandlers = true)
	{
		return TREE_CTRL_VAR.SetTree(tr);
	}
	
	
	void				InitTreeCntrl(int nID, bool bFlatDlgDisplay, bool bSubBranch, PEVENT_FUNC pfn, WndContainer& dlg, WndContainer* pParentDlg = NULL)
	{
#ifdef		_SPLITTER_CONTORL_H
		Control			ctrl = dlg.GetDlgItem(nID);
#else		// !_SPLITTER_CONTORL_H
		Control			ctrl = GetItem(nID);
#endif		// !_SPLITTER_CONTORL_H
		TREE_CTRL_VAR.CreateControl(ctrl.GetSafeHwnd());
	}


protected:
	Tree				m_paramTree;
	//TreeEditControl		m_treeEditCntrl;
	DynaControl		TREE_CTRL_VAR;
};


/*
#define ON_GETNDLG_MSGS(_ID) \
	ON_GRID_BEFORE_EDIT(_ID, OnBeforeEdit)	\
	ON_GRID_VALIDATE_EDIT(_ID, OnValidateEdit)	\
	ON_GRID_AFTER_EDIT(_ID, OnAfterEdit)	\
	ON_GRID_ROW_COL_CHANGE(_ID, OnRowColChange)	\
	ON_GRID_COMBO_CLOSEUP(_ID, OnComboCloseUp)	\
	ON_GRID_BEFORE_MOUSE_DOWN(_ID, OnBeforeMouseDown)	\
	ON_GRID_BUTTON_CLICK(_ID, OnButtonClick) \
	ON_GRID_DRAW_CELL(_ID, OnDrawCell) \
	ON_GRID_CELL_CHANGE(_ID, OnCellChange) \
	ON_GRID_CHANGE_EDIT(_ID, OnChangeEdit) \
	ON_EVENT(EN_SETFOCUS, _ID, OnSetFocus) \
	ON_USER_MSG(WM_USER_ON_CHILD_KILL_FOCUS, OnEditorKillFocus) \
	ON_USER_MSG(WM_USER_RECONSTRUCT, OnReconstructGrid) \
	
	ON_GRID_BEFORE_MOVE_ROWS(_ID, OnBeforeMoveRows)	\
	ON_GRID_AFTER_MOVE_ROWS(_ID, OnAfterMoveRows)	\
	
	ON_CONTEXTMENU(OnShowMenu) 

*/

#define ON_GETNDLG_MSGS(_ID) \
	ON_USER_MSG(WM_USER_RECONSTRUCT, OnReconstructGrid)


	
#ifdef		_SPLITTER_CONTORL_H
	

#define RIGHT_PANE_ROW_COL 0,1

//////////////////////////////////////////////////////////////////////////////
// class TreeEditSplitter2
// this class supports a DynaControl in on main and another pane called
// the MainPane, which can be either a regular control (CreateMainPane) or
// an ActiveX control (CreateMainActiveXPane)
//////////////////////////////////////////////////////////////////////////////
class TreeEditSplitter2 : public TreeEditDlg2
{
public:
	TreeEditSplitter2(bool bHorz = true, bool bTreeEditSecond = true)
	{
		m_bHorz = bHorz;
		m_bTreeEdit2ndCntrl = bTreeEditSecond;
	}
	void Init(int nCntrlID, WndContainer& wndParent, int nIndex, LPCSTR lpcszDlgName)
	{
		m_bReady = false;
		// control ID for panes
		// Must init these IDs before calls to InitMsgMap
		SetGridSize(getNumRows(), getNumCols()); // must call this before calls to GetDlgCtrlID
		m_ID1stPane = GetDlgCtrlID();
		m_ID2ndPane = GetDlgCtrlID(getCntrlRow(1), getCntrlCol(1));
		InitMsgMap();
		//TreeEditDlg::Init(nCntrlID, wndParent, nIndex, lpcszDlgName);
		TreeEditDlg2::Init(nCntrlID, wndParent, nIndex, lpcszDlgName);
	}

protected:
	//---- CPY 9/3/04
	BOOL CreateWindow(int nID, HWND hWnd)
	{
		Window wndParent(hWnd);
		Init(nID, wndParent, 0, NULL);
		return TRUE;

	}
	//----
	
	///DG 6/13/05 GETN_GRAPH_DLG_NEEDED event handling
	virtual PEVENT_FUNC GetEventHandler()
	{
		return NULL;
	}
	void SetTreeEditPaneSize(int nSize, BOOL bPercent = TRUE)
	{
		int nIndex = m_bTreeEdit2ndCntrl ? 1 : 0;
		SetColSize(getCntrlCol(nIndex), nSize, bPercent);
	}
	int GetTreeEditPaneSize(BOOL bPercent = true)
	{
		int nSize=-1;
		int nIndex = m_bTreeEdit2ndCntrl ? 1 : 0;
		GetColSize(getCntrlCol(nIndex), nSize, bPercent);
		return nSize;
	}
	///end GETN_GRAPH_DLG_NEEDED
	//------------- CPY 9/2/05 GRAPH_TREE_SPLITTER_SAMPLE_CODE_CLEANUP
	void UpdateTreeEditPane()
	{
		//m_treeEditCntrl.SetReady(false);
		//m_treeEditCntrl.Update(m_paramTree, true, true);
		//m_treeEditCntrl.SetReady(true);
		update(m_paramTree, true, true);
	}
	//-------------
	// call this from ON_INIT
	BOOL CreateTreeEditPane()
	{
		GUID clsid;
		int nIndex = m_bTreeEdit2ndCntrl? 1:0;
		
		CreateActiveXPane(clsid, getCntrlRow(nIndex), getCntrlCol(nIndex));		
		
		PEVENT_FUNC pfn = GetEventHandler(); //NULL;// need to supply this for additional event handling
		///// AW 03/17/05 v8.0206 CLEANING_CODES_IN_FO 
		////ConstructTree();
		//m_treeEditCntrl.Init(GetTreeEditPaneID(), false, true, pfn, *this);	///DG INIT_ONE_TIME : move out from ConstructWithoutTree
		////m_treeEditCntrl.Update(m_paramTree, true, true);
		InitTreeCntrl(GetTreeEditPaneID(), false, true, pfn, *this);	///DG INIT_ONE_TIME : move out from ConstructWithoutTree
		ConstructWithoutTree();
		/// END CLEANING_CODES_IN_FO
		return TRUE;
	}
	// call this from ON_INIT for creating main pane as regular control
	BOOL CreateMainPane(Window &wnd)
	{
		int nIndex = m_bTreeEdit2ndCntrl? 0:1; 
		return CreatePane(wnd, getCntrlRow(nIndex), getCntrlCol(nIndex));
	}
	// call this from ON_INIT for creating main pane as ActiveX control
	BOOL CreateMainActiveXPane(GUID& clsid)
	{
		int nIndex = m_bTreeEdit2ndCntrl? 0:1; 
		return CreateActiveXPane(clsid, getCntrlRow(nIndex), getCntrlCol(nIndex));		
	}
	BOOL IsReady()	///Danice 11/12/04 : use to indicate init ready
	{
		return m_bReady;
	}
	BOOL SetReady()
	{
		m_bReady = true;
		return TreeEditDlg2::SetReady(); // must call this in order for the splitter to show
	}
		
	BOOL OnCtrlResize(int nType, int cx, int cy)
	{
		//TreeEditDlg::OnResize(nType, cx, cy);
		TreeEditDlg2::OnResize(nType, cx, cy);
		return TRUE;
	}
	virtual BOOL InitMsgMap() { return FALSE; }
	virtual void ConstructTree()
	{
		_DBSTR("calling base class ConstructTree")
		GETN_TREE(trTemp)
		GETN_NUM(StartLevel, "Start Level", 0)
		GETN_SLIDER(SearchRange, "Search Range(%)", 20, "1|51|50")
		GETN_COMBO(SearchLevels, "Num. of Levels", 5, "2|5|10|15|20|25|30|40|50")
		GETN_CHECK(Consolidate, "Consolidate Related Contours", true)
		m_paramTree = trTemp;
	}
	// ML 2/16/2006: I can't see that this function is used anywhere.
	/*
	void Update(bool bChkCellResize = false, bool bCheckComboChange = false, bool bCheckChanged = false)
	{
		m_treeEditCntrl.UpdateGridValues(bChkCellResize, bCheckComboChange, bCheckChanged);
	}
	*/
	int GetTreeEditPaneID() {return m_bTreeEdit2ndCntrl? m_ID2ndPane : m_ID1stPane;}
	int GetMainPaneID() {return m_bTreeEdit2ndCntrl? m_ID1stPane : m_ID2ndPane;}
	/// AW 03/17/05 v8.0206 CLEANING_CODES_IN_FO

public:
	
	BOOL LoadListSource( LPCSTR strFileName )
	{
		if ( TRUE == m_trFunctions.Load(strFileName) )
		{
			//m_trSplitter = m_trFunctions; ///DG 3/22/05 REMOVE_DUPLICATE
			SetListTree(m_trFunctions);
			return TRUE;
		}
		//ASSERT(FALSE);   //  false to open ListSourceFile, please add error string display here
		//return FALSE;
		return error_report("false to open list source file");
	}
	/// END  CLEANING_CODES_IN_FO
	//------------- CPY 9/2/05 GRAPH_TREE_SPLITTER_SAMPLE_CODE_CLEANUP
	TreeNode GetListTree()
	{
		TreeNode trTemp = m_trFunctions;
		
		return trTemp;
	}
	void UpdateListTree()
	{
		SetListTree(m_trFunctions);
	}
	//------------- end GRAPH_TREE_SPLITTER_SAMPLE_CODE_CLEANUP
	///DG 3/22/05 REMOVE_DUPLICATE
	bool SetListTree(TreeNode &tr)
	{
		if(!tr)
			return false;
		m_trSplitter=tr;
		return true;
	}
	///end REMOVE_DUPLICATE
private:
	int getCntrlRow(int nIndex = 0)
	{
		if(nIndex && !m_bHorz)
			return 1;
		return 0;
	}
	int getCntrlCol(int nIndex = 0)
	{
		if(nIndex && m_bHorz)
			return 1;
		return 0;
	}
	int getNumCols() {return m_bHorz? 2:1;}
	int getNumRows() {return m_bHorz? 1:2;}
	
protected:
	bool				m_bReady;
	int					m_ID1stPane;
	int					m_ID2ndPane;
	/// AW 03/17/05 v8.0206 CLEANING_CODES_IN_FO
	// move from derived class ListTreeEditSplitter
	TreeNode			m_trSel;	
	int 				m_nSelRow;	
	TreeNode			m_trSplitter;
	/// END CLEANING_CODES_IN_FO

private:
	bool				m_bHorz;
	bool				m_bTreeEdit2ndCntrl;
	Tree				m_trFunctions;//------------- CPY 9/2/05 GRAPH_TREE_SPLITTER_SAMPLE_CODE_CLEANUP, moved from public area
};

#endif		// _SPLITTER_CONTORL_H







//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#endif	// __GETNPREWDLG2_H_

 